/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.common.OrderedHashtable;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.jdm.eui.JDMWizard;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanel;
import ibm.nways.jdm.eui.MyScrollPane;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SectionContainer;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class PropertyBook
extends Panel
implements ItemListener,
ActionListener,
JDMWizard {
    private static ResourceBundle myResources = null;
    public static final int CANCEL = 1;
    public static final int HELP = 2;
    public static final int OK = 3;
    public static final int RESET = 4;
    public static Color selListBackColor = SystemColor.text;
    public static Color selListForeColor = SystemColor.textText;
    public static Color buttonForeground = SystemColor.controlText;
    public static Color buttonBackground = SystemColor.control;
    public static Color titleForeground = SystemColor.textHighlightText;
    public static Color titleBackground = SystemColor.textHighlight;
    protected Font labelFont;
    protected Font listFont;
    private String title;
    private List sectionList;
    private MyScrollPane sectionPane;
    private Panel sectionArea;
    private Panel sectionPanel;
    private OrderedHashtable sectionIndex;
    private Panel sectionButtons;
    private Button refeshButton;
    private Button applyButton;
    private Button helpButton;
    private Button createButton;
    private int numberOfWizardPanels;
    private CardLayout layout;
    protected JDMWizardInfo wizardInfo = new JDMWizardInfo();

    public PropertyBook() {
        try {
            myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.PropertyBookResources");
        }
        catch (Exception exception) {
            System.err.println("Unable to access translation resources for PropertyBook");
        }
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        this.sectionPanel = new Panel();
        this.sectionIndex = new OrderedHashtable();
        this.sectionList = new List();
        this.sectionPane = new MyScrollPane();
        this.sectionArea = new Panel();
        this.sectionButtons = new Panel();
        this.sectionList.setBackground(selListBackColor);
        this.sectionList.setForeground(selListForeColor);
        this.sectionPanel.setLayout(new BorderLayout());
        this.sectionButtons.setLayout(new FlowLayout());
        this.sectionArea.setLayout(new ColumnLayout());
        this.sectionPane.setInterior(this.sectionArea);
        this.sectionPanel.add("West", this.sectionList);
        this.sectionPanel.add("Center", this.sectionPane);
        this.sectionPanel.add("South", this.sectionButtons);
        this.add("main", this.sectionPanel);
        this.doLayout();
        this.sectionList.addItemListener(this);
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void addSection(String string, PropertySection propertySection) {
        SectionContainer sectionContainer = new SectionContainer(string, propertySection);
        this.sectionArea.add(sectionContainer);
        this.sectionList.add(string);
        this.sectionIndex.put(string, sectionContainer);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Component component = (Component)this.sectionIndex.get(this.sectionList.getSelectedItem());
            this.sectionPane.setScrollPosition(component.getLocation());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == this.refeshButton) {
            this.reset();
        }
        if (button == this.applyButton) {
            this.apply();
        }
        if (button == this.helpButton) {
            this.help();
        }
        if (button == this.createButton) {
            this.create();
        }
    }

    protected void help() {
    }

    public void setTitle(String string) {
        Label label = new Label("  " + string);
        label.setBackground(titleBackground);
        label.setForeground(titleForeground);
        this.sectionPanel.add("North", label);
    }

    public void deleteSection(PropertySection propertySection) {
    }

    public String getClassVersion() {
        return new String("");
    }

    public void scrollToSection(int n) {
    }

    public void handleEvent() {
    }

    public void buttonPress(int n) {
    }

    public void getTitleBar() {
    }

    public void initParams() {
    }

    public void setControl(Component component) {
    }

    public void setCreateMenu(Component component) {
    }

    public void setIcon(Image image) {
    }

    public void setIcon(String string) {
    }

    public void setNavigator(Component component) {
    }

    public void setSelectedMenu(Component component) {
    }

    public void setPolicy(String string) {
    }

    public Font getLabelFont() {
        return new Font("SansSerif", 1, 12);
    }

    public Component getControl() {
        return null;
    }

    public Component getCreateMenu() {
        return null;
    }

    public Component getSelectedMenu() {
        return null;
    }

    public String paramString() {
        return "";
    }

    public void reset() {
        Enumeration enumeration = this.sectionIndex.elements();
        while (enumeration.hasMoreElements()) {
            PropertySection propertySection = ((SectionContainer)enumeration.nextElement()).section;
            propertySection.reset();
        }
    }

    public void apply() {
        System.out.println("Apply() executing in PropertyBook");
        Enumeration enumeration = this.sectionIndex.elements();
        while (enumeration.hasMoreElements()) {
            PropertySection propertySection = ((SectionContainer)enumeration.nextElement()).section;
            propertySection.apply();
        }
    }

    protected void create() {
        this.layout.next(this);
    }

    protected void addApplyButton() {
        this.applyButton = new Button(PropertyBook.getNLSString("applyButtonLabel"));
        this.applyButton.setForeground(buttonForeground);
        this.applyButton.setBackground(buttonBackground);
        this.applyButton.addActionListener(this);
        this.sectionButtons.add(this.applyButton);
    }

    protected void addRefreshButton() {
        this.refeshButton = new Button(PropertyBook.getNLSString("refreshButtonLabel"));
        this.refeshButton.setForeground(buttonForeground);
        this.refeshButton.setBackground(buttonBackground);
        this.refeshButton.addActionListener(this);
        this.sectionButtons.add(this.refeshButton);
    }

    protected void addHelpButton() {
        this.helpButton = new Button(PropertyBook.getNLSString("helpButtonLabel"));
        this.helpButton.setForeground(buttonForeground);
        this.helpButton.setBackground(buttonBackground);
        this.helpButton.addActionListener(this);
        this.sectionButtons.add(this.helpButton);
    }

    protected void addCreateButton() {
        this.createButton = new Button(PropertyBook.getNLSString("createButtonLabel"));
        this.createButton.setForeground(buttonForeground);
        this.createButton.setBackground(buttonBackground);
        this.createButton.addActionListener(this);
        this.sectionButtons.add(this.createButton);
    }

    public void addWizardPanel(JDMWizardPanel jDMWizardPanel) {
        ++this.numberOfWizardPanels;
        jDMWizardPanel.setWizard(this);
        this.add("p" + this.numberOfWizardPanels, jDMWizardPanel);
    }

    public JDMWizardInfo getInfo() {
        return this.wizardInfo;
    }

    public Vector getWizardPanels() {
        Vector<Component> vector = new Vector<Component>();
        int n = 0;
        while (n < this.getComponentCount()) {
            Component component = this.getComponent(n);
            if (component instanceof JDMWizardPanel) {
                vector.addElement(component);
            }
            ++n;
        }
        return vector;
    }

    public void next() {
        this.layout.next(this);
    }

    public void previous() {
        this.layout.previous(this);
    }

    public void first() {
        this.layout.first(this);
    }

    public void last() {
        this.layout.last(this);
    }

    public void cancel() {
        this.layout.first(this);
    }
}

